% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{viz_thermal_boxplot}
\alias{viz_thermal_boxplot}
\title{Generate Publication-Ready Comparative Boxplots}
\usage{
viz_thermal_boxplot(
  data,
  y_var,
  x_var,
  fill_var = NULL,
  add_points = TRUE,
  point_size = 1.5,
  point_alpha = 0.6,
  palette = "npg"
)
}
\arguments{
\item{data}{Data frame. The merged dataset (e.g., output from \code{\link{aggregate_replicates}}).}

\item{y_var}{String. The name of the numeric column to plot (e.g., "Max", "Mean").}

\item{x_var}{String. The name of the categorical column for the X-axis groupings.}

\item{fill_var}{String. The name of the variable used for fill colors. Default is \code{NULL}, which uses \code{x_var}.}

\item{add_points}{Logical. If \code{TRUE} (default), overlays individual data points using \code{geom_jitter}.
Highly recommended to show sample size and distribution density.}

\item{point_size}{Numeric. The size of the individual jitter points. Default is 1.5.}

\item{point_alpha}{Numeric. The transparency of the jitter points (0 to 1). Default is 0.6.}

\item{palette}{String or Vector.
\itemize{
  \item If a string: Pre-defined scientific palettes (\code{"npg"}, \code{"jco"}).
  \item If a character vector: A custom list of hex codes.
}}
}
\value{
A \code{ggplot} object. Can be further customized with standard ggplot2 functions (e.g., \code{+ ylim(20, 40)}).
}
\description{
Creates a high-quality box-and-whisker plot to visualize the distribution of thermal metrics across groups.
             This function is ideal for displaying median values, quartiles, and range, while optionally overlaying
             individual data points to reveal the underlying sample distribution.
}
\details{
This function includes several automated optimizations for scientific reporting:
         \itemize{
           \item \strong{Smart Outlier Handling:} If \code{add_points} is \code{TRUE}, the function automatically hides
                 the standard boxplot outliers (\code{outlier.shape = NA}) to avoid plotting the same data point twice
                 (once as an outlier, once as a jittered point).
           \item \strong{Palette Expansion:} Like the barplot function, it automatically interpolates colors if the number
                 of experimental groups exceeds the palette's limit.
           \item \strong{Layout:} Uses \code{theme_classic()} for a clean, academic look.
         }
}
\examples{
df_bio <- data.frame(
  Treatment = rep(c("ND", "HFD"), each = 5),
  Mean = c(runif(5, 33, 35), runif(5, 34, 36))
)

# Boxplot with individual points
p <- viz_thermal_boxplot(df_bio, y_var = "Mean", x_var = "Treatment")
p
}
