% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRadius.R
\name{getRadius}
\alias{getRadius}
\title{Estimate the Radius of a Circle Fitting Four Points}
\usage{
getRadius(frame)
}
\arguments{
\item{frame}{The plot or frame to display the points and interact with the user.}
}
\value{
A vector of length 3, where:
  - The first element is the x-coordinate of the circle center (cx).
  - The second element is the y-coordinate of the circle center (cy).
  - The third element is the radius of the circle (r).
}
\description{
This function estimates the center and radius of a circle that best fits four points provided by the user.
The user interacts with the plot to select four points, and the function optimizes the parameters 
(center and radius) using a least squares approach.
}
\details{
The function plots the provided `frame` and then uses the `locator()` function to allow the user 
to click on four points. The function then performs optimization using the `optim()` function to 
minimize the difference between the selected points and the circle's equation.

The objective function (`ftemp`) calculates the sum of squared differences between the points 
and the expected distance from the circle's center.
}
\examples{
if(interactive()){
path <- system.file('extdata/data.tiff', package='BioTrajectory')
im <- tiff::readTIFF(path)
im <- imager::as.cimg(t(im[,,1]))
frame <- plot(im)
circle_params <- getRadius(frame)
print(circle_params)
}

}
