% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isClosed.R
\name{isClosed}
\alias{isClosed}
\title{Check if the first and last points of a "trajectory" object are within a given tolerance}
\usage{
isClosed(obj, tol = 1e-06)
}
\arguments{
\item{obj}{An object of class `trajectory` that contains a component `points`.}

\item{tol}{A numeric value specifying the tolerance. If the distance between the first and 
last points is smaller than this value, the function returns `TRUE`. Default is `1e-6`.}
}
\value{
A logical value (`TRUE` or `FALSE`), indicating whether the distance between the first 
and last points is smaller than `tol`.
}
\description{
This function checks if the distance between the first and last points in an object of class 
`trajectory` is smaller than a specified tolerance `tol`. The distance is calculated using the 
Euclidean distance between the two points.
}
