% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothTrajectory.R
\name{smoothTrajectory}
\alias{smoothTrajectory}
\title{Apply a moving average filter to the trajectory and create a smoothed trajectory}
\usage{
smoothTrajectory(obj, method = c("x", "y", "both"), window = 3)
}
\arguments{
\item{obj}{An object of class `trajectory` that contains a component `points`, which is a 
data frame with the coordinates of the points. It is assumed that `points` has columns `x` 
and `y` representing the trajectory coordinates.}

\item{method}{A character string specifying which coordinate(s) to smooth. Can be one of 
`"x"`, `"y"`, or `"both"`. Default is `"both"`, which smooths both the `x` and `y` coordinates.}

\item{window}{An odd integer specifying the window size for the moving average filter. 
The window must be an odd number to ensure a symmetric filter. Default is 3.}
}
\value{
A new trajectory object created using the smoothed `x` and `y` coordinates.
}
\description{
This function applies a moving average filter to the `x` and/or `y` coordinates of a 
"trajectory" object. The filter is applied using a window of a specified size. The function 
then creates a new trajectory object using the smoothed coordinates. The filter is applied 
symmetrically around each point.
}
