% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{BRISE_v.stat}
\alias{BRISE_v.stat}
\title{Block-wise Statistic (Vectorized Form)}
\usage{
BRISE_v.stat(R, sample1ID, sample2ID, ptn_list)
}
\arguments{
\item{R}{Numeric symmetric rank matrix (N × N).}

\item{sample1ID}{Integer vector. Indices of observations in X.}

\item{sample2ID}{Integer vector. Indices of observations in Y.}

\item{ptn_list}{List of integer vectors that indexes observations sharing the same missing pattern.}
}
\value{
Numeric vector containing the sums of R entries within X and Y, for each pattern pair.
}
\description{
For the vectorized version of BRISE, computes the within-pattern rank sums for both samples across all pattern pairs. Returns a concatenated vector of (Ux_ab, Uy_ab) for all blocks (a, b) with a>b.
}
\keyword{internal}
