% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{galaxy}
\alias{galaxy}
\title{Galaxy Data}
\format{
A data frame with 270 rows and 3 variables:
\describe{
\item{mag}{Magnitude category (1-18)}
\item{red}{Redshift category (1-15)}
\item{freq}{Number of galaxies in this bin}
}
}
\source{
\url{https://hastie.su.domains/CASI_files/DATA/galaxy.txt}
}
\description{
Counts of galaxies binned by redshift and magnitude, from Table 8.5. The data
have been reshaped into long format with variables for magnitude, redshift
category, and frequency count.
}
\examples{
data(galaxy)
str(galaxy)

library(car)

## Fit a main effects Poisson GLM
# This treats `mag` and `red` as numeric
galaxy.mod0 <- glm(freq ~ mag + red,
                   data = galaxy, family = poisson)
Anova(galaxy.mod0)

## Fit response surface model
galaxy.mod1 <- glm(freq ~ poly(mag,2) +
                     poly(red, 2) +
                     mag : red,
                   data = galaxy, family = poisson)
Anova(galaxy.mod1)
summary(galaxy.mod1)
}
\references{
Efron, B. and Hastie, T. (2016). \emph{Computer Age Statistical Inference}.
Cambridge University Press, Table 8.5.
}
