% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{wrapper_xgboost}
\alias{wrapper_xgboost}
\title{Extreme Gradient Boosting wrapper for CCI}
\usage{
wrapper_xgboost(
  formula,
  data,
  train_indices,
  test_indices,
  metric,
  nrounds = 500,
  metricfunc = NULL,
  nthread = 1,
  eps = 1e-15,
  subsample = 1,
  ...
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame}

\item{train_indices}{Indices for training data}

\item{test_indices}{Indices for training data}

\item{metric}{Type of metric ("RMSE", "Kappa" or "Log Loss")}

\item{nrounds}{Number of boosting rounds}

\item{metricfunc}{A user specific metric function which have the arguments data, model test_indices and test_matrix and returns a numeric value}

\item{nthread}{Integer. Number of threads to use for parallel computation during model training in XGBoost. Default is 1.}

\item{eps}{Small value to avoid log(0) in LogLoss calculations. Default is 1e-15.}

\item{subsample}{Numeric. The proportion of the data to be used for subsampling. Default is 1 (no subsampling).}

\item{...}{Additional arguments passed to xgb.train}
}
\value{
Performance metric
}
\description{
Extreme Gradient Boosting wrapper for CCI
}
