% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCohortSet.R
\name{generateCohortSetLocal}
\alias{generateCohortSetLocal}
\title{Generate a cohort set on a local CDM (list of dataframes)}
\usage{
generateCohortSetLocal(
  cdm,
  cohortSet,
  name,
  computeAttrition = TRUE,
  overwrite = TRUE
)
}
\arguments{
\item{cdm}{A local cdm object (list of dataframes, e.g. from
\code{dplyr::collect(cdm)}).}

\item{cohortSet}{A cohort set from \code{\link{readCohortSet}}.}

\item{name}{Name of the cohort table to create.}

\item{computeAttrition}{Whether to compute attrition.}

\item{overwrite}{Whether to overwrite an existing cohort table.}
}
\value{
The input \code{cdm} with the new cohort table added (as local
dataframes).
}
\description{
Copies the local CDM to an in-memory DuckDB database, runs
\code{\link{generateCohortSet}}, then collects the generated cohort table
and its attributes back into R and adds them to the input CDM.
}
\keyword{internal}
