% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetArchiveImage.R
\name{GetArchiveImage}
\alias{GetArchiveImage}
\title{Get image from the archive (deprecated)}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Process.html}
}
\arguments{
\item{aoi}{sf or sfc object, typically a (multi)polygon, describing the Area of Interest.}

\item{bbox}{numeric vector of four elements describing the bounding box of interest.
    Specify with a coordinate pair on two (opposite) vertices of the bounding box rectangle.
    Coordinates need to be in longitude, latitude.

Only one of either \code{aoi} or \code{bbox} may be specified.}

\item{time_range}{scalar or vector (Date or character that can be converted to date) defining the time interval.}

\item{collection}{character indicating which collection to search.
Must be one of the collections returned by \code{GetCollections}.}

\item{script}{a length one character string containing the evaluation script or the name of the file containing the script.}

\item{mosaicking_order}{character indicating the order in which tiles are overlapped from which the output result is mosaicked.
Must be one of "mostRecent", "leastRecent", or "leastCC". Default: "mostRecent"}

\item{file}{name of the file to save the image. If NULL, a \code{SpatRaster} object is returned. Default: NULL}

\item{format}{character indicating the output file format.
Must be one of "image/tiff", "image/png", or "image/jpeg". Default: "image/tiff"}

\item{pixels}{integer scalar or length-two vector indicating the request image width and height.
Values must be integers between 1 and 2500.}

\item{resolution}{numeric scalar or length-two vector indicating the spatial resolution of the request image
    in horizontal and vertical direction (in meters).

Only one of the arguments "pixels" or "resolution" must be set at the same time.
If the argument "pixels" or "resolution" is scalar, the same value is used for horizontal and vertical direction (width and height).}

\item{buffer}{numeric, width of the buffer to retrieve the image of enlarged area. Default: 0}

\item{mask}{logical indicating if the image should contain only pixels within Area of Interest. Default: FALSE}

\item{client}{OAuth client object to use for authentication.}

\item{token}{OAuth token character string to use for authentication.

Exactly one of either \code{client} or \code{token} must be specified. It is recommended to use \code{client}.}

\item{url}{character indicating the process endpoint. Default: Copernicus Data Space Ecosystem process endpoint}
}
\value{
\code{SpatRaster} object (from the package \code{terra}) of the requested image (if \code{file} is \code{NULL}),
    or the (invisible) name of the file created.
}
\description{
Retrieves the image for the area of interest using the parameters provided.
}
\details{
If \code{aoi} argument is provided, the result is returned in the same coordinate reference system.
}
\examples{
\dontrun{
dsn <- system.file("extdata", "centralpark.geojson", package = "CDSE")
aoi <- sf::read_sf(dsn, as_tibble = FALSE)
script_file <- system.file("scripts", "NDVI_uint8.js", package = "CDSE")
day <- "2023-07-11"
ras <- GetArchiveImage(aoi = aoi, time_range = day, script = script_file,
       collection = "sentinel-2-l2a",format = "image/tiff",
       mosaicking_order = "leastCC", resolution = 10, client = OAuthClient)
}
}
\seealso{
\code{\link[CDSE]{GetCollections}}, \code{\link[CDSE]{SearchCatalog}}

\code{\link{CDSE-deprecated}}
}
