% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_interactions.R
\name{check_interactions}
\alias{check_interactions}
\title{Check Pairwise Interactions in Logistic Regression}
\usage{
check_interactions(data, variables, yval, rounding = NULL, strata = NULL)
}
\arguments{
\item{data}{A data frame containing the outcome variable and predictor variables.}

\item{variables}{A character vector of predictor variables to test for pairwise interactions.}

\item{yval}{A string naming the binary outcome variable.}

\item{rounding}{Optional integer specifying the number of decimal places to round the output. Defaults to \code{NULL} (no rounding).}

\item{strata}{A string naming the stratification variable for conditional logistic regression (CLR). Defaults to \code{NULL}, meaning standard logistic regression is used.}
}
\value{
A data frame showing the log-likelihood, likelihood ratio test statistic (G), and p-value
for each pairwise interaction tested. The first row corresponds to the main-effects model.
}
\description{
Evaluates all pairwise interactions between provided predictor variables in a logistic regression model.
It compares models that include individual interaction terms to a main-effects model using likelihood ratio tests.
Supports both standard logistic regression and conditional logistic regression (CLR) when stratification is provided.
}
\details{
This function fits a logistic regression model using the variables in \code{variables},
then iteratively fits additional models that include each pairwise interaction. The models are
compared using likelihood ratio tests via \code{lmtest::lrtest}. If \code{strata} is provided,
conditional logistic regression (CLR) is used instead of standard logistic regression.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 4, Table 4.14

# Evaluate potential interaction terms among predictors.
# Variables included in the final main effects model to evaluate potential interactions
var.names <- c('age', 'height', 'priorfrac', 'momfrac', 'armassist', 'raterisk_cat')

# Recode 'raterisk' into a binary categorical variable 'raterisk_cat'
glow500<-dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c('Less', 'Same') ~ 'C1',
    raterisk == 'Greater' ~ 'C2'))

# Run the interaction-checking procedure
check_interactions(data = glow500, variables = var.names, yval = 'fracture', rounding = 4)

}
