% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit_prob_plot.R
\name{logit_prob_plot}
\alias{logit_prob_plot}
\title{Plot Predicted Probabilities from a Logistic Model}
\usage{
logit_prob_plot(
  data,
  ypredict = NULL,
  model = NULL,
  parameters = NULL,
  intercept = NULL,
  outcome,
  predictors.plot
)
}
\arguments{
\item{data}{A data frame containing the original data used to fit the model.}

\item{ypredict}{Optional. A matrix of posterior predictive simulations of the outcome variable
(e.g., generated externally). If \code{NULL}, predictions will be simulated internally assuming a single-level logistic regression.
The matrix should have dimensions \code{S x N}, where \code{S} is the number of posterior draws (rows) and \code{N} is the number of observations (columns).}

\item{model}{A fitted Stan model object of class \code{'stanfit'} (from \code{rstan}). Required if \code{ypredict} is not provided.}

\item{parameters}{A named vector where the names are the predictor variable names (as in the data), and the values are the corresponding parameter names in the Stan model. Required if \code{ypredict} is not provided.}

\item{intercept}{Optional. A character string indicating the name of the intercept parameter
in the Stan model (if present).}

\item{outcome}{A character string with the name of the binary outcome variable in the data.}

\item{predictors.plot}{A character vector of length 2 specifying which two predictor variables
to use for the x and y axes of the plot.}
}
\value{
A \code{ggplot2} object showing the mean predicted probabilities across the grid of the
two specified predictors, with the observed outcome overlaid as colored points.
}
\description{
This function visualizes the predicted probabilities from a Bayesian logistic regression model
fitted using \code{rstan}. It computes the posterior predicted probabilities over a grid defined by
two continuous predictor variables, and creates a plot showing how these probabilities vary
across their values. Color is used to represent the estimated probability, and the original
data points are overlaid for reference.
}
