% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osius_rojek.R
\name{osius_rojek}
\alias{osius_rojek}
\title{Osius and Rojek Goodness-of-Fit Test for Logistic Regression}
\usage{
osius_rojek(model)
}
\arguments{
\item{model}{A logistic regression model fitted with \code{glm()}.}
}
\value{
A list containing the following measures:
\item{z_chisq}{The standardized Z-statistic based on the Pearson chi-square approximation.}
\item{p_value}{The two-sided p-value associated with \code{z_chisq}.}
\item{z_s}{The standardized Z-statistic based on the sum-of-squares approximation.}
\item{p_value_S}{The two-sided p-value associated with \code{z_s}.}
}
\description{
Applies the Osius and Rojek normal approximation to assess the overall goodness-of-fit
of a logistic regression model. This includes:
\itemize{
\item A normal approximation to the distribution of the Pearson chi-square statistic.
\item A normal approximation to the distribution of the sum-of-squares statistic.
}
}
\details{
This function implements the Osius and Rojek test as described in Hosmer et al. (2013)
for assessing the goodness-of-fit of logistic regression models.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Section 5.2.2

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Apply the Osius and Rojek test for goodness-of-fit
osius_rojek(model.int)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc.
}
\seealso{
\code{\link{cov.patterns}}
}
