% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_logistic.R
\name{residuals_logistic}
\alias{residuals_logistic}
\title{Model Diagnostic for Logistic Regression Models}
\usage{
residuals_logistic(model)
}
\arguments{
\item{model}{A fitted logistic regression model of class \code{glm}.}
}
\value{
A list containing:
\item{x.cv}{A data frame with the computed residuals and diagnostic measures for each observation, and their respective covariates.}
\item{leverage}{A ggplot object displaying leverage vs. estimated probability.}
\item{change.Pearsonchi}{A ggplot object displaying the change in Pearson chi-squared vs. estimated probability.}
\item{change.deviance}{A ggplot object displaying the change in deviance vs. estimated probability.}
\item{cooks}{A ggplot object displaying Cook's distance vs. estimated probability.}
\item{change.Pb}{A ggplot object displaying the change in Pearson chi-squared vs. Estimated Probability with size determinate by Cook's distance.}
}
\description{
This function computes various residuals and diagnostic measures for logistic regression models,
including Pearson residuals, standardized Pearson residuals, deviance residuals, leverage, and delta statistics
(change in Pearson chi-squared, change in deviance, and change in Cook's distance).
The function also generates diagnostic plots for evaluating the model fit and identifying influential data points.
}
\details{
The residuals and diagnostic measures are computed using standard formulas for logistic regression
(adapted from Hosmer et al., 2013, \emph{Applied Logistic Regression}, 3rd ed.). The following measures are computed:
\itemize{
\item Pearson residuals
\item Standardized Pearson residuals
\item Deviance residuals
\item Leverage
\item Delta statistics: Delta beta (change in Cook's distance), Delta chi (change in Pearson chi-squared) and Delta deviance
}

Additionally, the function generates the following plots:
\itemize{
\item Leverage vs. Estimated Probability
\item Change in Pearson chi-squared vs. Estimated Probability
\item Change in Deviance vs. Estimated Probability
\item Cook's Distance vs. Estimated Probability
\item Change in Pearson chi-squared vs. Estimated Probability
\item Change in Pearson chi-squared vs. Estimated Probability with size determinate by Cook's distance.
}
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Section 5.3

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Run diagnostics for the logistic model
residuals_logistic(model.int)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc. The formulas for calculating residuals and diagnostics are adapted from this source.
}
\seealso{
\code{\link{cov.patterns}}
}
