% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_results.R
\name{summarize_results}
\alias{summarize_results}
\title{Summarize Bayesian Logistic Regression Model Results}
\usage{
summarize_results(
  model,
  ypredict = NULL,
  data,
  outcome,
  intercept = NULL,
  var.param,
  rounding = 2,
  prob = 0.8,
  point.est = "median"
)
}
\arguments{
\item{model}{A fitted model object of class \code{stanfit}, from \code{rstan} or \code{stanreg}, from \code{rstanarm}, representing a single-level logistic regression.}

\item{ypredict}{Optional. A matrix of posterior predictive simulations of the outcome variable
(e.g., generated externally). If \code{NULL}, predictions will be simulated internally assuming a single-level logistic regression.
The matrix should have dimensions \code{S x N}, where \code{S} is the number of posterior draws (rows) and \code{N} is the number of observations (columns).}

\item{data}{A data frame containing the variables used in the model.}

\item{outcome}{A character string specifying the name of the binary outcome variable in \code{data}.}

\item{intercept}{Optional. A character string naming the intercept parameter in the model. Defaults to \code{NULL}.}

\item{var.param}{A named character vector mapping dataset variable names to model parameter names.
When \code{ypredict} is \code{NULL}, the variable names must exist in \code{data} for posterior prediction. If \code{ypredict} is provided, this check is skipped since predictions are supplied directly.}

\item{rounding}{An integer specifying the number of decimal places for printed parameter summaries. Must be a non-negative integer. Default is 2.}

\item{prob}{A numeric value between 0 and 1 specifying the width of the credible interval for posterior plots (e.g., 0.8 for 80\% intervals). Default is 0.8.}

\item{point.est}{Character string, either \code{"mean"} or \code{"median"}, indicating the point estimate to use in posterior plots. Default is median.}
}
\value{
A list with the following components:
\describe{
\item{posterior_plot}{A \code{ggplot} object showing posterior distributions of the coefficients.}
\item{ppc_mean}{A \code{ggplot} object showing the posterior predictive check for the point estimate.}
\item{ppc_sd}{A \code{ggplot} object showing the posterior predictive check for the standard deviation.}
}
Also prints parameter summaries and displays plots.
}
\description{
This function provides a visual and numeric summary of a Bayesian logistic regression model
fitted with \code{rstan}. It displays posterior distributions of selected parameters and performs
posterior predictive checks based on either user-provided simulations or internal simulations.
}
