% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvfitted.R
\name{fitted.clv.fitted}
\alias{fitted.clv.fitted}
\title{Extract Unconditional Expectation}
\usage{
\method{fitted}{clv.fitted}(object, prediction.end = NULL, verbose = FALSE, ...)
}
\arguments{
\item{object}{A fitted clv model for which the unconditional expectation is desired.}

\item{prediction.end}{{} Until what point in time to predict. This can be the number of periods (numeric) or a form of date/time object. See details.}

\item{verbose}{Show details about the running of the function.}

\item{...}{Ignored}
}
\value{
A \code{data.table} which contains the following columns:
\item{period.until}{The timepoint that marks the end (up until and including) of the period to which the data in this row refers.}
\item{period.num}{The number of this period. }
\item{expectation}{The value of the unconditional expectation for the period that ends on \code{period.until}.}
}
\description{
Extract the unconditional expectation (future transactions unconditional on being "alive") from a fitted clv model.
This is the unconditional expectation data that is used when plotting the fitted model.
}
\details{
\code{prediction.end} indicates until when to predict or plot and can be given as either
a point in time (of class \code{Date}, \code{POSIXct}, or \code{character}) or the number of periods.
If \code{prediction.end} is of class character, the date/time format set when creating the data object is used for parsing.
If \code{prediction.end} is the number of periods, the end of the fitting period serves as the reference point
from which periods are counted. Only full periods may be specified.
If \code{prediction.end} is omitted or NULL, it defaults to the end of the holdout period if present and to the
end of the estimation period otherwise.

The first prediction period is defined to start right after the end of the estimation period.
If for example weekly time units are used and the estimation period ends on Sunday 2019-01-01, then the first day
of the first prediction period is Monday 2019-01-02. Each prediction period includes a total of 7 days and
the first prediction period therefore will end on, and include, Sunday 2019-01-08. Subsequent prediction periods
again start on Mondays and end on Sundays.
If \code{prediction.end} indicates a timepoint on which to end, this timepoint is included in the prediction period.
}
\seealso{
\code{\link[CLVTools:plot.clv.fitted.transactions]{plot}} to plot the unconditional expectation
}
