% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_SaveExp.R
\name{SaveExp}
\alias{SaveExp}
\title{Save a multidimensional array with metadata to data in NetCDF format}
\usage{
SaveExp(
  data,
  destination = tempdir(),
  coords = NULL,
  Dates = NULL,
  time_bounds = NULL,
  startdates = NULL,
  varname = NULL,
  metadata = NULL,
  Datasets = NULL,
  sdate_dim = "sdate",
  ftime_dim = "time",
  memb_dim = "member",
  dat_dim = "dataset",
  var_dim = "var",
  drop_dims = NULL,
  single_file = FALSE,
  extra_string = NULL,
  global_attrs = NULL,
  units_hours_since = FALSE
)
}
\arguments{
\item{data}{A multi-dimensional array with named dimensions.}

\item{destination}{A character string indicating the path where to store the 
NetCDF files.}

\item{coords}{A named list with elements of the coordinates corresponding to 
the dimensions of the data parameter. The names and length of each element 
must correspond to the names of the dimensions. If any coordinate is not 
provided, it is set as an index vector with the values from 1 to the length 
of the corresponding dimension.}

\item{Dates}{A named array of dates with the corresponding sdate and forecast 
time dimension. If there is no sdate_dim, you can set it to NULL. 
It must have ftime_dim dimension.}

\item{time_bounds}{(Optional) A list of two arrays of dates containing 
the lower (first array) and the upper (second array) time bounds 
corresponding to Dates. Each array must have the same dimensions as Dates.
If 'Dates' parameter is NULL, 'time_bounds' are not used. It is NULL by 
default.}

\item{startdates}{A vector of dates that will be used for the filenames 
when saving the data in multiple files (single_file = FALSE). It must be a 
vector of the same length as the start date dimension of data. It must be a 
vector of class \code{Dates}, \code{'POSIXct'} or character with lenghts 
between 1 and 10. If it is NULL, the coordinate corresponding the the start 
date dimension or the first Date of each time step will be used as the name 
of the files. It is NULL by default.}

\item{varname}{A character string indicating the name of the variable to be 
saved.}

\item{metadata}{A named list where each element is a variable containing the
corresponding information. The information must be contained in a list of 
lists for each variable.}

\item{Datasets}{A vector of character string indicating the names of the 
datasets.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. By default, it is set to 'sdate'. It can be NULL if there is no
start date dimension.}

\item{ftime_dim}{A character string indicating the name of the forecast time
dimension. By default, it is set to 'time'. It can be NULL if there is no 
forecast time dimension.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. By default, it is set to 'member'. It can be NULL if there is no 
member dimension.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
By default, it is set to 'dataset'. It can be NULL if there is no dataset  
dimension.}

\item{var_dim}{A character string indicating the name of variable dimension. 
By default, it is set to 'var'. It can be NULL if there is no variable  
dimension.}

\item{drop_dims}{(optional) A vector of character strings indicating the 
dimension names of length 1 that need to be dropped in order that they don't 
appear in the netCDF file. Only is allowed to drop dimensions that are not 
used in the computation. The dimensions used in the computation are the ones 
specified in: sdate_dim, ftime_dim, dat_dim, var_dim and memb_dim. It is 
NULL by default.}

\item{single_file}{A logical value indicating if all object is saved in a 
single file (TRUE) or in multiple files (FALSE). When it is FALSE, 
the array is separated for datasets, variable and start date. When there are 
no specified time dimensions, the data will be saved in a single file by 
default. The output file name when 'single_file' is TRUE is a character 
string containing: '<var>_<first_sdate>_<last_sdate>.nc'; when it is FALSE, 
it is '<var>_<sdate>.nc'. It is FALSE by default.}

\item{extra_string}{(Optional) A character string to be included as part of 
the file name, for instance, to identify member or realization. When 
single_file is TRUE, the 'extra_string' will substitute all the default 
file name; when single_file is FALSE, the 'extra_string' will be added 
in the file name as: '<var>_<extra_string>_<sdate>.nc'. It is NULL by 
default.}

\item{global_attrs}{(Optional) A list with elements containing the global 
attributes to be saved in the NetCDF.}

\item{units_hours_since}{(Optional) A logical value only available for the 
case: Dates have forecast time and start date dimension, single_file is 
TRUE and 'time_bounds' is NULL. When it is TRUE, it saves the forecast time 
with units of 'hours since'; if it is FALSE, the time units will be a number 
of time steps with its corresponding frequency (e.g. n days, n months or n 
hours). It is FALSE by default.}
}
\value{
Multiple or single NetCDF files containing the data array.\cr
\item{\code{single_file is TRUE}}{
 All data is saved in a single file located in the specified destination  
 path with the following name (by default): 
 '<variable_name>_<first_sdate>_<last_sdate>.nc'. Multiple variables
 are saved separately in the same file. The forecast time units 
 are calculated from each start date (if sdate_dim is not NULL) or from 
 the time step. If 'units_hours_since' is TRUE, the forecast time units 
 will be 'hours since <each start date>'. If 'units_hours_since' is FALSE, 
 the forecast time units are extracted from the frequency of the time steps 
 (hours, days, months); if no frequency is found, the units will be ’hours 
 since’. When the time units are 'hours since' the time ateps are assumed to 
 be equally spaced.
}
\item{\code{single_file is FALSE}}{
 The data array is subset and stored into multiple files. Each file 
 contains the data subset for each start date, variable and dataset. Files 
 with different variables and datasets are stored in separated directories 
 within the following directory tree: 'destination/Dataset/variable/'. 
 The name of each file will be by default: '<variable_name>_<sdate>.nc'. 
 The forecast time units are calculated from each start date (if sdate_dim 
 is not NULL) or from the time step. The forecast time units will be 'hours 
 since <each start date>'.
}
}
\description{
This function allows to save a data array with metadata into a 
NetCDF file, allowing to reload the saved data using \code{Start} function 
from StartR package. If the original 's2dv_cube' object has been created from 
\code{CST_Load()}, then it can be reloaded with \code{Load()}.
}
\examples{
\donttest{
data <- lonlat_temp_st$exp$data
lon <- lonlat_temp_st$exp$coords$lon
lat <- lonlat_temp_st$exp$coords$lat
coords <- list(lon = lon, lat = lat)
Datasets <- lonlat_temp_st$exp$attrs$Datasets
varname <- 'tas'
Dates <- lonlat_temp_st$exp$attrs$Dates
metadata <- lonlat_temp_st$exp$attrs$Variable$metadata
SaveExp(data = data, coords = coords, Datasets = Datasets, varname = varname, 
       Dates = Dates, metadata = metadata, single_file = TRUE, 
       ftime_dim = 'ftime', var_dim = 'var', dat_dim = 'dataset')
       
}

}
\author{
Perez-Zanon Nuria, \email{nuria.perez@bsc.es}
}
