% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_tracking.R
\name{set_seed}
\alias{set_seed}
\title{Set and Track Random Seed}
\usage{
set_seed(
  seed = NULL,
  kind = NULL,
  normal.kind = NULL,
  sample.kind = NULL,
  analysis_name = NULL,
  registry_file,
  set_seed = TRUE
)
}
\arguments{
\item{seed}{Numeric. Random seed to set. If NULL, generates random seed.}

\item{kind}{Character. RNG kind (see ?set.seed). Default NULL uses current.}

\item{normal.kind}{Character. Normal RNG kind. Default NULL uses current.}

\item{sample.kind}{Character. Sample RNG kind. Default NULL uses current.}

\item{analysis_name}{Character. Name to associate with this seed}

\item{registry_file}{Character. Path to seed registry (required).}

\item{set_seed}{Logical. If TRUE, actually sets the seed. If FALSE, only tracks it. Default TRUE.}
}
\value{
The seed value (invisibly)
}
\description{
Set a random seed and track it for reproducibility.
Note: This function is explicitly designed to set random seeds as requested by the user.
}
\examples{
\dontrun{
# Set and track a specific seed
set_seed(12345, analysis_name = "simulation_1",
         registry_file = tempfile(fileext = ".json"))

# Generate and track a random seed
set_seed(analysis_name = "bootstrap_analysis",
         registry_file = tempfile(fileext = ".json"))
}
}
