% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregateCovariates.R
\name{createAggregateCovariateSettings}
\alias{createAggregateCovariateSettings}
\title{Create aggregate covariate study settings}
\usage{
createAggregateCovariateSettings(
  targetIds,
  outcomeIds,
  minPriorObservation = 0,
  outcomeWashoutDays = 0,
  riskWindowStart = 1,
  startAnchor = "cohort start",
  riskWindowEnd = 365,
  endAnchor = "cohort start",
  covariateSettings = FeatureExtraction::createCovariateSettings(useDemographicsGender =
    TRUE, useDemographicsAge = TRUE, useDemographicsAgeGroup = TRUE, useDemographicsRace
    = TRUE, useDemographicsEthnicity = TRUE, useDemographicsIndexYear = TRUE,
    useDemographicsIndexMonth = TRUE, useDemographicsTimeInCohort = TRUE,
    useDemographicsPriorObservationTime = TRUE, useDemographicsPostObservationTime =
    TRUE, useConditionGroupEraLongTerm = TRUE, useDrugGroupEraOverlapping = TRUE,
    useDrugGroupEraLongTerm = TRUE, useProcedureOccurrenceLongTerm = TRUE, 
    
    useMeasurementLongTerm = TRUE, useObservationLongTerm = TRUE,
    useDeviceExposureLongTerm = TRUE, useVisitConceptCountLongTerm = TRUE,
    useConditionGroupEraShortTerm = TRUE, useDrugGroupEraShortTerm = TRUE,
    useProcedureOccurrenceShortTerm = TRUE, useMeasurementShortTerm = TRUE,
    useObservationShortTerm = TRUE, useDeviceExposureShortTerm = TRUE,
    useVisitConceptCountShortTerm = TRUE, endDays = 0, longTermStartDays = -365,
    shortTermStartDays = -30),
  caseCovariateSettings = createDuringCovariateSettings(useConditionGroupEraDuring =
    TRUE, useDrugGroupEraDuring = TRUE, useProcedureOccurrenceDuring = TRUE,
    useDeviceExposureDuring = TRUE, useMeasurementDuring = TRUE, useObservationDuring =
    TRUE, useVisitConceptCountDuring = TRUE),
  casePreTargetDuration = 365,
  casePostOutcomeDuration = 365,
  extractNonCaseCovariates = TRUE
)
}
\arguments{
\item{targetIds}{A list of cohortIds for the target cohorts}

\item{outcomeIds}{A list of cohortIds for the outcome cohorts}

\item{minPriorObservation}{The minimum time (in days) in the database a patient in the target cohorts must be observed prior to index}

\item{outcomeWashoutDays}{Patients with the outcome within outcomeWashout days prior to index are excluded from the risk factor analysis}

\item{riskWindowStart}{The start of the risk window (in days) relative to the `startAnchor`.}

\item{startAnchor}{The anchor point for the start of the risk window. Can be `"cohort start"`
or `"cohort end"`.}

\item{riskWindowEnd}{The end of the risk window (in days) relative to the `endAnchor`.}

\item{endAnchor}{The anchor point for the end of the risk window. Can be `"cohort start"`
or `"cohort end"`.}

\item{covariateSettings}{An object created using \code{FeatureExtraction::createCovariateSettings}}

\item{caseCovariateSettings}{An object created using \code{createDuringCovariateSettings}}

\item{casePreTargetDuration}{The number of days prior to case index we use for FeatureExtraction}

\item{casePostOutcomeDuration}{The number of days prior to case index we use for FeatureExtraction}

\item{extractNonCaseCovariates}{Whether to extract aggregate covariates and counts for patients in the targets and outcomes in addition to the cases}
}
\value{
A list with the settings
}
\description{
Create aggregate covariate study settings
}
\examples{

aggregateSetting <- createAggregateCovariateSettings(
  targetIds = c(1,2),
  outcomeIds = c(3),
  minPriorObservation = 365,
  outcomeWashoutDays = 90,
  riskWindowStart = 1,
  startAnchor = "cohort start",
  riskWindowEnd = 365,
  endAnchor = "cohort start",
  casePreTargetDuration = 365,
  casePostOutcomeDuration = 365
)

}
\concept{Aggregate}
