% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_wear.R
\name{screen_wear}
\alias{screen_wear}
\title{Screen wear and extract the longest valid minute-level segment}
\usage{
screen_wear(
  df,
  min_days = 5L,
  max_zero_run = 120L,
  date_col = "Date",
  time_col = "Time",
  activity_col = "Activity"
)
}
\arguments{
\item{df}{\code{data.frame} with columns \code{Date}, \code{Time}, \code{Activity} in time order.}

\item{min_days}{Integer minimum number of whole days required (default 5).}

\item{max_zero_run}{Integer maximum allowed length (minutes) of a run of zeros.}

\item{date_col}{Name of the date column.}

\item{time_col}{Name of the time column.}

\item{activity_col}{Name of the activity column used to determine wear/non-wear.}
}
\value{
A list with elements:
\describe{
\item{status}{\code{"ok"} if a qualifying segment is found, otherwise a message.}
\item{epoch_inferred}{Detected original epoch in seconds (15, 30, 60).}
\item{out_idx}{Indices of the kept segment in the input.}
\item{clean_df}{Minute-level \code{data.frame} of the selected segment (if ok).}
}
}
\description{
Determines the native epoch from the first two time stamps, decimates to
1-minute resolution (if needed), checks total minutes \eqn{\ge} \code{1440*min_days},
and within that finds the \strong{longest} contiguous segment where runs of
consecutive zeros do not exceed \code{max_zero_run} minutes.
}
\details{
Decimation rule: 15 s \eqn{\rightarrow} factor 4; 30 s \eqn{\rightarrow} factor 2;
60 s \eqn{\rightarrow} factor 1. The zero-run criterion is applied on the
1-minute \code{Activity} series.
}
\seealso{
\code{\link[=import_acti_file]{import_acti_file()}}, \code{\link[=sleep_cos]{sleep_cos()}}, \code{\link[=sleep_detection]{sleep_detection()}}
}
