% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TemplateUnion.R
\name{createUnionCohortTemplate}
\alias{createUnionCohortTemplate}
\title{Create cohort template to union multiple cohorts}
\usage{
createUnionCohortTemplate(cohortIds, cohortName, unionCohortId)
}
\arguments{
\item{cohortIds}{A vector of `cohort_definition_id` values for the input cohorts.}

\item{cohortName}{The Name of the resulting cohort}

\item{unionCohortId}{The `cohort_definition_id` for the resulting union cohort.}
}
\description{
This is a union between all cohorts within a specified set of ids.
If an individual has multiple overlapping eras, they will be merged into a single time window.

Distinct eras will be mapped to the same cohort id but remain distinct.
For example:

```
A:         [--------]
B:             [--]
C:                 [-------]
```
Becomes:
```
A U B U C: [--------------]
```

And
```
A:     [--------]
B:                    [-------]
```
Becomes
```
A U B:  [--------]     [-------]
```
It is never allowed to have multiple overlapping eras for the same individual within a cohort
}
