% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GM.R
\name{GM}
\alias{GM}
\title{GM: Goodman Method for Simultaneous Confidence Intervals}
\usage{
GM(inpmat, alpha)
}
\arguments{
\item{inpmat}{Integer vector of observed cell counts corresponding to
a categorical dataset. Must contain non-negative values.}

\item{alpha}{Desired statistical significance level}
}
\value{
Prints the original and adjusted confidence intervals for each
category, as well as the overall volume of the simultaneous confidence
intervals.
}
\description{
Computes simultaneous confidence intervals for multinomial proportions
using the Goodman (1965) method. The function calculates lower and upper
confidence limits for each category, adjusts them to remain within the
[0, 1] range, and computes the overall interval volume (the product of
interval widths).
}
\details{
This function implements the simultaneous confidence interval method
proposed by Goodman (1965) for multinomial proportions. It adjusts each
interval to ensure the limits fall within the valid probability range.
}
\examples{
y <- c(44, 55, 43, 32, 67, 78)
z <- 0.05
GM(y, z)

}
\references{
Goodman, L. A. (1965). *On Simultaneous Confidence Intervals for Multinomial
Proportions.* Technometrics, **7**, 247–254.
}
\seealso{
\code{\link{BMDE}}, \code{\link{WALD}}, \code{\link{WS}}
}
\author{
Dr. M. Subbiah
}
