\name{clust.plot}
\alias{clust.plot}
\title{
Visualization of the \eqn{K}--means algorithm results
}

\description{
Visualization of the \eqn{K}--means algorithm results.
}

\usage{
clust.plot(mod, x)
}

\arguments{
\item{mod}{
The output of the kmeans() function.
}
\item{x}{
A matrix with the data.
}
}

\details{
The function performs PCA and plots the data onto the first two dimensions, constructs the convex hull of the groups and plots them with different colours.
}

\value{
A plot.
}

\references{
Tsagris M. and Kontemeniotis N. (2025). Simplicial clustering using the \eqn{\alpha}--transformation. https://arxiv.org/pdf/2509.05945.

Tsagris M.T., Preston S. and Wood A.T.A. (2011). A data-based power transformation
for compositional data. In Proceedings of the 4th Compositional Data Analysis
Workshop, Girona, Spain. https://arxiv.org/pdf/1106.1451.pdf

Garcia-Escudero Luis A., Gordaliza Alfonso, Matran Carlos, Mayo-Iscar Agustin. (2008). A general
trimming approach to robust cluster analysis. Annals of Statistics 36(3): 1324--1345.
}

\author{
Michail Tsagris.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{cikmeans}
}
}

\examples{
y <- as.matrix(iris[, 1:4])
y <- y / rowSums(y)
z <- CompositionalClust::alfa(y, 1)
mod <- alfa.kmeans( z, ncl = 3, a = 1 )
clust.plot(mod[[ 1 ]], z )
}

