% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_conservation_calcs.R
\name{add_conservation_calcs}
\alias{add_conservation_calcs}
\title{Add Conservation Risks}
\usage{
add_conservation_calcs(mydata, Temp = "Temp", RH = "RH", ...)
}
\arguments{
\item{mydata}{A dataframe containing temperature and relative humidity data.}

\item{Temp}{Character string name of the temperature column (default "Temp").}

\item{RH}{Character string name of the relative humidity column (default "RH").}

\item{...}{Additional parameters passed to humidity calculation functions.}
}
\value{
Dataframe augmented with conservation variables:

\describe{
  \item{Mould_LIM}{Mould risk threshold humidity from Zeng equation (numeric).}
  \item{Mould_risk}{If there is a risk of mould from Zeng equation.
     Adds label: "Mould risk" or "No risk".}
  \item{Mould_rate}{Mould growth rate index from Zeng equation, labelled output.}
  \item{Mould_index}{Mould risk index from VTT model (continuous scale).}
  \item{PreservationIndex}{Preservation Index for collection longevity.}
  \item{Lifetime}{Lifetime Multiplier for object material degradation risk.}
  \item{EMC_wood}{Wood equilibrium moisture content (\%) under current climate conditions.}
}
}
\description{
Appends columns for conservation-risks: mould risk, preservation indices, equilibrium moisture,
and moisture content for wood to a dataframe with temperature and relative humidity columns.
}
\examples{

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> add_conservation_calcs() |> dplyr::glimpse()


}
\seealso{
\code{\link{calcMould_Zeng}} for `Mould_LIM`, `Mould_risk`, `Mould_rate`

\code{\link{calcMould_VTT}} for `Mould_index`

\code{\link{calcPI}} for `PreservationIndex`

\code{\link{calcLM}} for `Lifetime`

\code{\link{calcEMC_wood}} for `EMC_wood`
}
