% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCovTest1.mxPBF.R
\name{BCovTest1.mxPBF}
\alias{BCovTest1.mxPBF}
\title{One-Sample Covariance Test using Maximum Pairwise Bayes Factor}
\usage{
BCovTest1.mxPBF(data, Sigma0 = diag(ncol(data)), a0 = 2, b0 = 2, gamma = 1)
}
\arguments{
\item{data}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}

\item{a0}{shape parameter for inverse-gamma prior.}

\item{b0}{scale parameter for inverse-gamma prior.}

\item{gamma}{non-negative number. See the equation above.}
}
\value{
a named list containing: \describe{
\item{log.BF.mat}{a \eqn{(p\times p)} matrix of pairwise log Bayes factors.}
}
}
\description{
It performs Bayesian version of 1-sample test for Covariance where the null hypothesis is
\deqn{H_0 : \Sigma_n = \Sigma_0}
where \eqn{\Sigma_n} is the covariance of data model and \eqn{\Sigma_0} is a
hypothesized covariance. Denote \eqn{X_i} be the \eqn{i}-th column of data matrix.
Under the maximum pairwise Bayes Factor framework, we have following hypothesis,
\deqn{H_0: a_{ij}=0~\mathrm{ and }~\tau_{ij}=1 \quad \mathrm{versus. } \quad  H_1: \mathrm{ not }~ H_0.}
The model is
\deqn{X_i | X_j \sim N_n( a_{ij}X_j, \tau_{ij}^2 I_n )}
and the prior is set, under \eqn{H_1},  as
\deqn{ a_{ij}|\tau_{ij}^2 \sim N(0, \tau_{ij}^2/(\gamma*||X_j||^2))}
\deqn{\tau_{ij}^2 \sim IG(a0, b0).}
}
\examples{
\dontrun{
## generate data from multivariate normal with trivial covariance.
pdim = 10
data = matrix(rnorm(100*pdim), nrow=100)

## run mxPBF-based test
out1 = BCovTest1.mxPBF(data)
out2 = BCovTest1.mxPBF(data, a0=5.0, b0=5.0) # change some params

## visualize two Bayes Factor matrices
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
image(exp(out1$log.BF.mat)[,pdim:1], main="default")
image(exp(out2$log.BF.mat)[,pdim:1], main="a0=b0=5.0")
par(opar)
}

}
\references{
\insertRef{lee_maximum_2018}{CovTools}
}
