% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_joins.R
\name{map_join_paths}
\alias{map_join_paths}
\title{Discover Potential Join Paths from Metadata and Data}
\usage{
map_join_paths(metadata_dt, data_list = NULL)
}
\arguments{
\item{metadata_dt}{A data.table containing the master metadata.}

\item{data_list}{A named list of data.tables (names match \code{table_name} in \code{metadata_dt}).
If provided, scans data to find inferred join paths. Defaults to \code{NULL}.}
}
\value{
A \code{data.table} representing the "Join Map" with columns:
\code{table_from}, \code{table_to}, \code{key_from}, \code{key_to}
}
\description{
Analyzes metadata for explicit joins and optionally scans data to infer
additional joins. Handles single- and multi-variable join keys.
}
