% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dfactor.tests.R
\name{Dfactor.tests}
\alias{Dfactor.tests}
\title{Distributed Factor Model Testing with Wald, GRS, PY tests and FDR control}
\usage{
Dfactor.tests(ret, fac, n1, K, q.fdr = 0.05)
}
\arguments{
\item{ret}{A T × N matrix representing the excess returns of N assets at T time points.}

\item{fac}{A T × K matrix representing the returns of K factors at T time points.}

\item{n1}{The number of assets allocated to each node}

\item{K}{The number of nodes}

\item{q.fdr}{The significance level for FDR (False Discovery Rate) testing, defaulting to 5\%.}
}
\value{
A list containing the following components:
\item{alpha_list}{List of alpha vectors from each node}
\item{tstat_list}{List of t-statistics from each node}
\item{pval_list}{List of p-values from each node}
\item{Wald_list}{List of Wald test statistics from each node}
\item{p_Wald_list}{List of p-values for Wald tests from each node}
\item{GRS_list}{List of GRS test statistics from each node}
\item{p_GRS_list}{List of p-values for GRS tests from each node}
\item{PY_list}{List of Pesaran and Yamagata test statistics from each node}
\item{p_PY_list}{List of p-values for PY tests from each node}
\item{reject_fdr_list}{List of logical vectors indicating significant assets after FDR correction from each node}
\item{power_proxy_list}{List of number of significant assets after FDR correction from each node}
\item{combined_alpha}{Combined alpha vector from all nodes}
\item{combined_pval}{Combined p-value vector from all nodes}
\item{combined_reject_fdr}{Combined FDR rejection vector from all nodes}
\item{total_power_proxy}{Total number of significant assets across all nodes after FDR correction}
}
\description{
Performs comprehensive factor model testing in distributed environment across multiple nodes,
including joint tests (Wald, GRS, PY), individual asset t-tests, and False Discovery Rate control.
}
\examples{
set.seed(42)
T <- 120
N <- 100  # Larger dataset for distributed testing
K_factors <- 3
fac <- matrix(rnorm(T * K_factors), T, K_factors)
beta <- matrix(rnorm(N * K_factors), N, K_factors)
alpha <- rep(0, N)
alpha[1:10] <- 0.4 / 100  # 10 non-zero alphas
eps <- matrix(rnorm(T * N, sd = 0.02), T, N)
ret <- alpha + fac \%*\% t(beta) + eps

# Distributed testing with 4 nodes, each handling 25 assets
results <- Dfactor.tests(ret, fac, n1 = 25, K = 4, q.fdr = 0.05)

# View combined results
cat("Total significant assets after FDR:", results$total_power_proxy, "\n")
cat("Combined results across all nodes:\n")
print(summary(results$combined_alpha))

}
