% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LFM.R
\name{LFM}
\alias{LFM}
\title{Generate Laplace factor models}
\usage{
LFM(n, p, m, distribution_type)
}
\arguments{
\item{n}{An integer specifying the sample size.}

\item{p}{An integer specifying the sample dimensionality or the number of variables.}

\item{m}{An integer specifying the number of factors in the model.}

\item{distribution_type}{A character string indicating the type of distribution to use
for generating the data.}
}
\value{
A list containing the following elements:
\item{data}{A numeric matrix of the generated data.}
\item{A}{A numeric matrix representing the factor loadings.}
\item{D}{A numeric matrix representing the uniquenesses, which is a diagonal matrix.}
}
\description{
The function is to generate Laplace factor model data.
The function supports various distribution types for generating the data,
including:
- `truncated_laplace`: Truncated Laplace distribution
- `log_laplace`: Univariate Symmetric Log-Laplace distribution
- `Asymmetric Log_Laplace`: Log-Laplace distribution
- `Skew-Laplace`: Skew-Laplace distribution
}
\examples{
n <- 1000
p <- 10
m <- 5
sigma1 <- 1
sigma2 <- matrix(c(1,0.7,0.7,1), 2, 2)
distribution_type <- "Asymmetric Log_Laplace"
results <- LFM(n, p, m, distribution_type)
print(results)
}
