%  file man/Nutrimouse.Rd
%  Documentation for the Nutrimouse dataset
%---------------------
\name{Nutrimouse}
\alias{Nutrimouse}
\docType{data}
\encoding{UTF-8}
\title{Nutrimouse: Gene, Lipid and Grouping Data}

\description{
  A data frame containing gene expression, lipid measurements, and grouping variables (diet and genotype) for 40 mice from a nutrigenomics study.
}

\usage{data(Nutrimouse)}

\format{
  A data frame with 40 observations on 143 variables:
  \itemize{
    \item 120 numeric variables for gene expression
    \item 21 numeric variables for lipid measurements
    \item 2 categorical variables: \code{diet} and \code{genotype}
  }
}

\details{
  This dataset was created for integrative analysis of transcriptomic and lipidomic responses of mice to different diets and genotypes.

  All numeric variables (genes and lipids) are centered and scaled. The categorical variables indicate the experimental design: five diet types and two genotypes.

  This format is convenient for regression, classification, and dimension reduction techniques requiring a single data frame.
}

\source{
  Extracted from the \pkg{mixOmics} package, based on: \\
  Martin, P. G. P., et al. (2007).
  \emph{A systems biology approach to the study of gene expression and lipid metabolism in mice fed high-fat diets}.
  \emph{Journal of Lipid Research}, \bold{48}(2), 360--377.
}

\references{
  González, I., Déjean, S., Martin, P. G. P., and Baccini, A. (2009).
  CCA: An R package to extend canonical correlation analysis.
  \emph{Journal of Statistical Software}, \bold{23}(12), 1--14.
}

\examples{
data(Nutrimouse)

# View structure
str(Nutrimouse)

# Boxplot of a gene across diets
boxplot(Nutrimouse[,1] ~ Nutrimouse$diet, main = "Gene 1 Expression by Diet")

# PCA on all numeric variables (excluding factors)
nutri_numeric <- Nutrimouse[, sapply(Nutrimouse, is.numeric)]
pca_result <- prcomp(nutri_numeric, scale. = TRUE)

# PCA plot
plot(pca_result$x[,1:2], col = as.numeric(Nutrimouse$diet), pch = 19)
legend("topright", legend = levels(Nutrimouse$diet), col = 1:5, pch = 19)
}

\keyword{datasets}
