% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Generate density plots}
\usage{
plot_density(max_min_values_list, D, Dt_max = TRUE, risk_measures)
}
\arguments{
\item{max_min_values_list}{A list generated by \code{\link[=get_max_min_values]{get_max_min_values()}}}

\item{D}{A single threshold value}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}

\item{risk_measures}{A list of risk scores generated by \code{\link[=calculate_risk]{calculate_risk()}}.
The policy alternatives in the \code{risk_measures} list must be in the same order
as in the \code{max_min_values_list}.}
}
\value{
A list of ggplots, one for each policy alternative.
}
\description{
For each policy alternative, this function generates
probability density plots of the highest (or lowest if the threshold is a
minimum) projected outcome across simulation runs. The decision threshold
is shown directly on the plot as a vertical line. The area under the
probability density curve where the threshold value is exceeded is shaded
to visually display the downside risk of the policy alternative.
}
\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
Dt <- rep(750, nrow(psa_data$Baseline))
D <- 750

risk_measures <- calculate_risk(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt = Dt,
  Dt_max = TRUE
)

peak_values_list <- get_max_min_values(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt_max = TRUE
)

density_plots <- plot_density(
  peak_values_list,
  D = D,
  Dt_max = TRUE,
  risk_measures
)
}
