% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fan.R
\name{plot_fan}
\alias{plot_fan}
\title{Generate time-outcome fan plots}
\usage{
plot_fan(data, tmin, tmax, Dt, Dt_max = TRUE)
}
\arguments{
\item{data}{A list of data.frames (one data.frame for each policy
alternative).}

\item{tmin}{A numeric value or a date specifying the minimum simulation time
to include in the analysis (ex. 1 or "2021-01-01"). This should correspond to a value in the first
column of each data.frame in \code{data}.}

\item{tmax}{A numeric value or a date specifying the maximum simulation time to
include in the analysis (ex. 100 or "2021-04-10"). This should correspond to a value in the first
column of each data.frame in \code{data}.}

\item{Dt}{A numeric vector of decision thresholds, one for each model
time step between \code{tmin} and \code{tmax}.}

\item{Dt_max}{A logical value indicating whether the decision threshold
is a maximum (\code{TRUE}) or a minimum (\code{FALSE}). The default is \code{TRUE}.}
}
\value{
A list of ggplots, one for each policy alternative.
}
\description{
For each policy alternative, this function generates time-outcome
fan plots summarizing the trajectory of the outcome over time using the mean value for
a given policy alternative. Uncertainty is characterized by shading the
50\% and 95\% credible intervals (calculated as 25th and 75th percentiles and
2.5th and 97.5th percentiles, respectively). The decision threshold is shown
directly on the plot to provide a clear reference point for interpreting
the outcome values.
}
\section{\code{data} format}{

Each data.frame in \code{data} contains the results from multiple model
runs using different parameter sets (e.g., from probabilistic sensitivity,
uncertainty, or Bayesian inference analysis). The first column contains
the model time and subsequent columns contain the predicted output for
each simulation run at the respective time.
The model time in the first column must contain numeric values indicating
a simulation time (ex. 1, 2, 3,...) or dates (ex. "2021-01-01", "2021-01-02")
which must be in \code{R} Date format (i.e., class="Date"). To ensure a consistent
basis for comparison, the model time in the first column should be the same for
each policy alternative (data.frame).
}

\examples{
tmin <- "2021-01-01"
tmax <- "2021-04-10"
Dt <- rep(750, nrow(psa_data$Baseline))

fan_plots <- plot_fan(
  psa_data,
  tmin = tmin,
  tmax = tmax,
  Dt = Dt,
  Dt_max = TRUE
)
}
