% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/besmi.R
\name{besmi_iterative_imputation}
\alias{besmi_iterative_imputation}
\title{Iterative imputation with MICE (tails-chain)}
\usage{
besmi_iterative_imputation(
  M_input,
  M_mask,
  M_real = NULL,
  method = "lasso.norm",
  max_iterations = 5,
  imputation_convergence_threshold = 0.001,
  propagation_convergence_threshold = 0.001,
  distance_metric = "mae",
  k = NA,
  bs_i = NA
)
}
\arguments{
\item{M_input}{Matrix with NAs to impute}

\item{M_mask}{Logical mask matrix (TRUE indicates masked positions)}

\item{M_real}{Optional ground truth matrix}

\item{method}{MICE method (e.g., 'lasso.norm')}

\item{max_iterations}{Max outer iterations}

\item{imputation_convergence_threshold}{Threshold for imputation distance}

\item{propagation_convergence_threshold}{Threshold for propagation distance}

\item{distance_metric}{Distance metric name}

\item{k}{Dataset parameter k (for logging)}

\item{bs_i}{Bootstrap index (for logging)}
}
\value{
List with final_matrix, metrics, tails_chain
}
\description{
Iterative imputation with MICE (tails-chain)
}
