% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertResultsCase.R
\name{convertJsonResultsFileCase}
\alias{convertJsonResultsFileCase}
\title{Convert JSON results file case}
\usage{
convertJsonResultsFileCase(
  jsonFilePath,
  writeToFile,
  outputFolder = NA,
  outputFile = "",
  targetCase
)
}
\arguments{
\item{jsonFilePath}{Path to the JSON results file to be converted}

\item{writeToFile}{Whether or not to write the converted results back to a file (must be either TRUE or FALSE)}

\item{outputFolder}{The folder to output the converted JSON results file to}

\item{outputFile}{(OPTIONAL) File to write converted results JSON object to. Default is name of input file with a "_camel" or "_snake" postfix}

\item{targetCase}{Case into which the results file parameters should be converted (must be either "camel" or "snake")}
}
\value{
DQD results object (a named list)
}
\description{
Convert a DQD JSON results file between camelcase and (all-caps) snakecase. Enables viewing of pre-v.2.1.0 results files in later DQD versions, and vice versa
}
