% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_mixture.R
\name{DiSCo_mixture_solve}
\alias{DiSCo_mixture_solve}
\title{DiSCo_mixture_solve}
\usage{
DiSCo_mixture_solve(
  c_len,
  CDF.matrix,
  grid.min,
  grid.max,
  grid.rand,
  M,
  simplex
)
}
\arguments{
\item{c_len}{The number of controls}

\item{CDF.matrix}{The matrix of CDFs}

\item{grid.min}{Minimal value of the grid on which the CDFs are evaluated.}

\item{grid.max}{Maximal value of the grid on which the CDFs are evaluated.}

\item{grid.rand}{Random grid on which the CDFs are evaluated.}

\item{M}{Integer indicating the number of control quantiles to use in the DiSCo method. Default is 1000.}

\item{simplex}{Logical, indicating whether to use to constrain the optimal weights to the unit simplex. Default is FALSE, which only constrains the weights to sum up to 1 but allows them to be negative.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{distance.opt } The optimal value of the Wasserstein distance.
\item \code{mean } The optimal value of the Wasserstein barycenter.
\item \code{target.order } The target unit, ordered.
\item \code{weights.opt } The optimal weights.
}
}
\description{
The solver for the alternative mixture of distributions approach in the paper
}
\keyword{internal}
