% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{liver_cirrhosis_prednisone_df}
\alias{liver_cirrhosis_prednisone_df}
\title{Prednisone vs Placebo in Liver Cirrhosis}
\format{
A data frame with 2968 observations and 9 variables:
\describe{
  \item{ID}{Integer patient identifier}
  \item{Time}{Numeric time measurement}
  \item{death}{Integer death indicator}
  \item{obstime}{Numeric observation time}
  \item{proth}{Integer prothrombin index value}
  \item{Trt}{Factor with 2 levels indicating treatment group (prednisone/placebo)}
  \item{start}{Numeric start time}
  \item{stop}{Numeric stop time}
  \item{event}{Numeric event indicator}
}
}
\source{
Data taken from the \pkg{JSM} package version 1.0.1.
}
\usage{
data(liver_cirrhosis_prednisone_df)
}
\description{
This dataset, liver_cirrhosis_prednisone_df, is a data frame containing data from a randomized
control trial comparing prednisone (n=251) versus placebo (n=237) in 488 liver cirrhosis patients.
The dataset includes both survival and longitudinal measurements of prothrombin index development
over time, with 2968 total observations across 9 variables.
}
\details{
The dataset name has been kept as 'liver_cirrhosis_prednisone_df' to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
