% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-summary.R
\name{summary.DiscreteTestResults}
\alias{summary.DiscreteTestResults}
\title{Summarizing Discrete Test Results}
\usage{
\method{summary}{DiscreteTestResults}(object, ...)
}
\arguments{
\item{object}{object of class \code{\link{DiscreteTestResults}} to be summarised;
usually created by using one of the packages test functions,
e.g. \code{\link[=binom_test_pv]{binom_test_pv()}}, with \code{simple_output = FALSE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A \code{\link[=DiscreteTestResultsSummary]{summary.DiscreteTestResults}} R6 class
object.
}
\description{
\code{summary} method for class \code{\link{DiscreteTestResults}}.
}
\examples{
# binomial tests
obj <- binom_test_pv(0:5, 5, 0.4)
# print summary
summary(obj)
# extract summary table
smry <- summary(obj)
smry$get_summary_table()

}
