# Make torch writes go to a temp dir during checks
Sys.setenv(TORCH_HOME = tempdir())

# Skip tests cleanly if torch or its runtime are not available
skip_if_no_torch <- function() {
  if (!requireNamespace("torch", quietly = TRUE)) {
    testthat::skip("torch not installed")
  }
  if (isFALSE(get("torch_is_installed", asNamespace("torch"))())) {
    testthat::skip("torch runtime not installed")
  }
}

# Keep CRAN runs short
is_cran <- identical(Sys.getenv("NOT_CRAN"), "false")
small_cfg <- list(
  epochs = if (is_cran) 1L else 20L,
  hidden = if (is_cran) 10L else 100L,
  eps = if (is_cran) c(5L, 5L, 5L) else c(50L, 50L, 50L)
)
