% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{register_model_dia}
\alias{register_model_dia}
\title{Register a Diagnostic Model Function}
\usage{
register_model_dia(name, func)
}
\arguments{
\item{name}{A character string, the unique name to register the model under.}

\item{func}{A function, the R function implementing the diagnostic model.
This function should typically accept \code{X} (features) and \code{y} (labels)
as its first two arguments and return a \code{caret::train} object.}
}
\value{
NULL. The function registers the model function invisibly.
}
\description{
Registers a user-defined or pre-defined diagnostic model function
with the internal model registry. This allows the function to be called
later by its registered name, facilitating a modular model management system.
}
\examples{
\donttest{
# Example of a dummy model function for registration
my_dummy_rf_model <- function(X, y, tune = FALSE, cv_folds = 5) {
  message("Training dummy RF model...")
  # This is a placeholder and doesn't train a real model.
  # It returns a list with a structure similar to a caret train object.
  list(method = "dummy_rf")
}

# Initialize the system before registering
initialize_modeling_system_dia()

# Register the new model
register_model_dia("dummy_rf", my_dummy_rf_model)

# Verify that the model is now in the list of registered models
"dummy_rf" \%in\% names(get_registered_models_dia())
}
}
\seealso{
\code{\link{get_registered_models_dia}}, \code{\link{initialize_modeling_system_dia}}
}
