% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEdgeProbabilitiesSegs.R
\name{calculateEdgeProbabilitiesSegs}
\alias{calculateEdgeProbabilitiesSegs}
\title{Calculate edge probabilities for fixed segments.}
\usage{
calculateEdgeProbabilitiesSegs(prob.networks, cps, numNodes)
}
\arguments{
\item{prob.networks}{List containing the marginal posterior probabilities
for the edges of each network at each timepoint, from
\code{\link{calculateEdgeProbabilitiesTimePoints}}.}

\item{cps}{Changepoints defining the segments for which the edge
probabilities should be calculated. Note that these are global changepoints
that apply to the whole network.}

\item{numNodes}{Number of nodes in the network.}
}
\value{
Returns a list of length equal to the number of segments, with each
entry containing a matrix of size NumNodes by NumNodes which contains the
marginal edge probabilities for that segment.
}
\description{
This function calculates the marginal posterior probabilities for the edges
in each network for the specified segments.
}
\seealso{
\code{\link{calculateEdgeProbabilities}},

\code{\link{calculateEdgeProbabilitiesTimePoints}}
}
\author{
Frank Dondelinger
}
