% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{init}
\alias{init}
\title{Initialise the MCMC simulation.}
\usage{
init(X, Y, sinit, GLOBvar, HYPERvar, options)
}
\arguments{
\item{X}{Input response data.}

\item{Y}{Input target data.}

\item{sinit}{Initial changepoints.}

\item{GLOBvar}{Global variables used during the MCMC simulation.}

\item{HYPERvar}{Hyperparameter variables.}

\item{options}{MCMC simulation options as obtained e.g. by
\code{\link{defaultOptions}}.}
}
\value{
List with elements: \item{counters}{Matrices for counting the number
of moves made and accepted.} \item{initState}{Initial state of the variables
of the MCMC simulation.} \item{listStock}{Variables for recording the
network, changepoint and hyperparameter samples.}
}
\description{
This function intialises the parameters and variables needed for the MCMC
simulation.
}
\seealso{
\code{\link{sampleParms}}
}
\author{
Sophie Lebre

Frank Dondelinger
}
