% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_audit_record.R
\name{get_audit_record}
\alias{get_audit_record}
\title{Get audit record}
\usage{
get_audit_record(oid, as = "data.frame", env = "production")
}
\arguments{
\item{oid}{(numeric) Audit identifier}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) An audit record
}
\description{
Get audit record
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Get audit report
auditReport <- get_audit_record(oid = "121606334")

logout()
}

}
\seealso{
Other Audit Manager Services: 
\code{\link{get_audit_count}()},
\code{\link{get_audit_csv_report}()},
\code{\link{get_audit_report}()},
\code{\link{get_docid_reads}()},
\code{\link{get_packageid_reads}()},
\code{\link{get_recent_uploads}()}
}
\concept{Audit Manager Services}
