% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_package_revisions.R
\name{list_data_package_revisions}
\alias{list_data_package_revisions}
\title{List data package revisions}
\usage{
list_data_package_revisions(
  scope,
  identifier,
  filter = NULL,
  env = "production"
)
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{identifier}{(numeric) Identifier of data package}

\item{filter}{(character) Filter results by "newest" or "oldest"}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) Revisions of a data package within a specified
\code{scope} and \code{identifier}
}
\description{
List data package revisions
}
\examples{
\dontrun{

# List revisions
revisions <- list_data_package_revisions("knb-lter-arc", 20131)
revisions
#> [1] 1 2
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
