% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_principal_owner_citations.R
\name{list_principal_owner_citations}
\alias{list_principal_owner_citations}
\title{List principal owner citations}
\usage{
list_principal_owner_citations(
  principalOwner,
  as = "data.frame",
  env = "production"
)
}
\arguments{
\item{principalOwner}{(character) The EDI ID of the principal owner. 
EDI IDs can be obtained from the EDI Identity and Access 
Manager (\url{https://auth.edirepository.org/auth/ui/signin}).}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Journal citations metadata for all 
entries owned by the specified principal owner
}
\description{
List principal owner citations
}
\examples{
\dontrun{

# List citations
edi_id <- "EDI-543afa80c859825d35d37d9111c24a4a65a0ff9e"
journalCitations <- list_principal_owner_citations(principalOwner = edi_id)
}
}
\seealso{
Other Journal Citations: 
\code{\link{create_journal_citation}()},
\code{\link{delete_journal_citation}()},
\code{\link{get_journal_citation}()},
\code{\link{list_data_package_citations}()}
}
\concept{Journal Citations}
