% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package.R
\name{read_data_package}
\alias{read_data_package}
\title{Read data package}
\usage{
read_data_package(packageId, ore = FALSE, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{ore}{(logical) Return an OAI-ORE compliant resource map in RDF-XML
format}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character or xml_document) A resource map with reference URLs to
each of the metadata, data, and quality report resources that comprise the
\code{packageId}.
}
\description{
Read data package
}
\examples{
\dontrun{
# Get resource map
resourceMap <- read_data_package(packageId = "knb-lter-cwt.5026.13")
resourceMap
#> [1] "https://pasta.lternet.edu/package/data/eml/knb-lter-cwt/5026/13/ ...
#> [2] "https://pasta.lternet.edu/package/data/eml/knb-lter-cwt/5026/13/ ...
#> [3] "https://pasta.lternet.edu/package/metadata/eml/knb-lter-cwt/5026 ...
#> [4] "https://pasta.lternet.edu/package/report/eml/knb-lter-cwt/5026/1 ...
#> [5] "https://pasta.lternet.edu/package/eml/knb-lter-cwt/5026/13" 

# Get resource map in ORE format
resourceMap <- read_data_package(
 packageId = "knb-lter-cwt.5026.13",
 ore = TRUE
)
resourceMap
#> {xml_document}
#> <RDF xmlns:cito="http://purl.org/spar/cito/" xmlns:dc="http://purl.or ...
#> [1] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [2] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [3] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [4] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [5] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [6] <rdf:Description rdf:about="https://pasta.lternet.edu/package/eml ...
#> [7] <rdf:Description rdf:about="http://environmentaldatainitiative.or ...
#> [8] <rdf:Description rdf:about="http://www.openarchives.org/ore/terms ...
#> [9] <rdf:Description rdf:about="http://www.openarchives.org/ore/terms ...
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
