% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_evaluate_report.R
\name{read_evaluate_report}
\alias{read_evaluate_report}
\title{Read evaluate report}
\usage{
read_evaluate_report(transaction, as = "xml", env = "production")
}
\arguments{
\item{transaction}{(character) Transaction identifier}

\item{as}{(character) Format of the returned report. Can be: "xml", "html",
or "char".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(xml_document or html_document or character) The evaluate quality
report document
}
\description{
Read evaluate report
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Evaluate data package
transaction <- evaluate_data_package(
  eml = paste0(tempdir(), "/edi.595.1.xml"),
  env = "staging"
)
transaction
#> [1] "evaluate_163966785813042760"

# Read as HTML and write to file for a web browser view
qualityReport <- read_evaluate_report(
  transaction = transaction,
  as = "html",
  env = "staging"
)
writeLines(qualityReport, paste0(tempdir(), "/report.html"))

# Read as character and write to file for browsing
qualityReport <- read_evaluate_report(
  transaction = transaction,
  as = "char",
  env = "staging"
)
writeLines(qualityReport, paste0(tempdir(), "/report.txt"))

# Read as XML
qualityReport <- read_evaluate_report(
  transaction = transaction,
  env = "staging"
)
qualityReport
#> {xml_document}
#> <qualityReport schemaLocation="eml://ecoinformatics.org/qualityReport ...
#> [1] <creationDate>2021-12-16T22:15:38</creationDate>
#> [2] <packageId>edi.606.1</packageId>
#> [3] <includeSystem>lter</includeSystem>
#> [4] <includeSystem>knb</includeSystem>
#> [5] <datasetReport>\n  <qualityCheck qualityType="metadata" system=" ...
#> [6] <entityReport>\n  <entityName>data.txt</entityName>\n  <qualityC ...

logout()
}

}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
