% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incremental_perturb_PCA.R
\name{incremental_perturb_pca}
\alias{incremental_perturb_pca}
\title{Incremental Perturbation PCA}
\usage{
incremental_perturb_pca(batch_data, m, eta = 0.1)
}
\arguments{
\item{batch_data}{List of matrices.}

\item{m}{Components.}

\item{eta}{Step size.}
}
\value{
List with Ap, Dp, V.
}
\description{
Batch-updated PCA with residual-projection perturbation.
}
\examples{
\dontrun{
set.seed(789)
N <- 50; m.true <- 2; n_batch <- 5
batches <- lapply(1:n_batch, function(i) matrix(rnorm(60 * N), 60, N))
inc <- EFM::incremental_perturb_pca(batches, m = m.true)
print(round(inc$Ap[1:5, 1:2], 3))
}
}
