% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResInd.R
\name{ResInd}
\alias{ResInd}
\title{A function to estimate resilience estimators (logarithm of variance, lag1 autocorrelation and skewness) based on daily milk production records}
\usage{
ResInd(
  production_df,
  dim_filter_range = c(1, 7, 203, 210),
  outlier_sd_threshold = 4,
  weight = "weight_AIC",
  trait,
  DIM,
  ID_col
)
}
\arguments{
\item{production_df}{The list containing the data frames with the daily production records (actual or predicted) obtained from the LacCurveFit function}

\item{dim_filter_range}{A vector containing the lower and upper limits to remove lactation records from the begin and end of the lactation, if needed. If it is not necessary to remove daily records, the first two values can be set as the minimum days in milk value and the last two as the maximum days in milk values}

\item{outlier_sd_threshold}{A threshold defining the maximum standard deviations to consider an individual resilience indicator value}

\item{weight}{The name of the column containing the selected ensemble prediction. The default is weight_AIC}

\item{trait}{The name of the column containing daily milking records}

\item{DIM}{The name of the column containing days in milk records}

\item{ID_col}{The name of the column containing the unique IDs of the individuals}
}
\value{
A list containing the daily milk production values after filtering, the list of removed animals, and a data frame with the resilience indicators
}
\description{
A function to estimate resilience estimators (logarithm of variance, lag1 autocorrelation and skewness) based on daily milk production records
}
