% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{compute_derivative}
\alias{compute_derivative}
\title{Compute Derivative of a Time Series}
\usage{
compute_derivative(
  Z,
  t = NULL,
  method = c("tvr", "savgol", "spline", "finite_diff", "spectral"),
  ...
)
}
\arguments{
\item{Z}{Numeric vector of observations.}

\item{t}{Numeric vector of time points (NULL assumes dt=1).}

\item{method}{Differentiation method: "tvr", "savgol", "spline",
"finite_diff", "fd", or "spectral".}

\item{...}{Additional arguments passed to the specific method.}
}
\value{
Numeric vector of estimated derivatives with diagnostic attributes.
}
\description{
Main dispatcher function for numerical differentiation. Supports multiple
methods appropriate for different data characteristics.
}
\details{
Available methods:
\itemize{
\item \strong{tvr}: Total Variation Regularized differentiation (recommended
for economic data with trends and shocks).
\item \strong{savgol}: Savitzky-Golay filter (moderate noise, preserves peaks).
\item \strong{spline}: Smoothing spline (high noise, prioritizes trend).
\item \strong{finite_diff} or \strong{fd}: Centered finite differences (low noise).
\item \strong{spectral}: FFT-based (periodic data only).
}
}
\examples{
t <- seq(0, 10, by = 0.1)
Z <- sin(t) + rnorm(length(t), sd = 0.1)

# Finite differences (fast, no dependencies)
dZ_fd <- compute_derivative(Z, t, method = "finite_diff")

# Access the derivative vector for plotting
plot(t, dZ_fd$derivative, type = "l", main = "Derivative Comparison")
lines(t, cos(t), col = "red", lty = 2) # True derivative

\donttest{
# TVR (requires CVXR)
if (requireNamespace("CVXR", quietly = TRUE)) {
  dZ_tvr <- compute_derivative(Z, t, method = "tvr")
}
}

}
\seealso{
\code{\link{compute_derivative_tvr}}, \code{\link{suggest_differentiation_method}}
}
