% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_search.R
\name{define_custom_operators}
\alias{define_custom_operators}
\title{Define Custom Operators}
\usage{
define_custom_operators(...)
}
\arguments{
\item{...}{Named functions to add as operators.}
}
\value{
List of operator definitions suitable for symbolic_search.
}
\description{
Defines custom mathematical operators for use in symbolic search.
}
\examples{
\donttest{
ops <- define_custom_operators(
  logistic = function(x, k = 1, x0 = 0) 1 / (1 + exp(-k * (x - x0))),
  threshold = function(x, c) ifelse(x > c, 1, 0)
)
}

}
