% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_analysis.R
\name{model_conditional_variance}
\alias{model_conditional_variance}
\title{Model Conditional Variance}
\usage{
model_conditional_variance(
  residuals,
  predictors,
  data = NULL,
  method = c("symbolic", "linear", "quadratic", "gam", "constant"),
  transform = c("absolute", "squared", "log_squared"),
  ...
)
}
\arguments{
\item{residuals}{Numeric vector of residuals}

\item{predictors}{Formula or data frame of predictor variables (or vector of names)}

\item{data}{Data frame (if predictors is a formula or vector of names)}

\item{method}{Modeling method: "symbolic", "linear", "quadratic", "gam", or "constant"}

\item{transform}{Transformation of residuals: "squared", "absolute", or "log_squared"}

\item{...}{Additional arguments passed to the modeling function}
}
\value{
An object of class "variance_model" containing the fitted model
}
\description{
Estimates how the residual variance depends on state variables, used
for constructing the diffusion term of an SDE.
}
