% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_parameter_samples}
\alias{extract_parameter_samples}
\title{Extract parameter samples from a Stan model}
\usage{
extract_parameter_samples(
  stan_fit,
  data,
  reported_dates,
  imputed_dates,
  reported_inf_dates,
  drop_length_1 = FALSE,
  merge = FALSE
)
}
\arguments{
\item{stan_fit}{A \verb{<stanfit>} or \verb{<CmdStanMCMC>} object as returned by
\code{\link[=fit_model]{fit_model()}}.}

\item{data}{A list of the data supplied to the simulation.}

\item{reported_dates}{A vector of dates to report estimates for.}

\item{imputed_dates}{A vector of dates to report imputed reports for.}

\item{reported_inf_dates}{A vector of dates to report infection estimates
for.}

\item{drop_length_1}{Logical; drop dimensions of length 1 in arrays extracted
from the stan fit. Used in simulations where there's only 1 realization.}

\item{merge}{if TRUE, merge samples into a single data.table using
rbindlist. If FALSE returns a list of samples by parameter.}
}
\value{
A list of \verb{<data.frame>}'s each containing the posterior of a
parameter
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function has been deprecated. Use \code{\link[=format_simulation_output]{format_simulation_output()}} for
simulation outputs or \code{\link[=get_samples]{get_samples()}} for estimation outputs instead.
}
\keyword{internal}
